-- events for main menu

shopitems = {}
activeitems = {}
horspacing = 150
verspacing = 160
falpha = 0
timer = 0
delay = 0
currentinfo = -1
prevcurrentinfo = -1
mouseoverareaw = 90
mouseoverareah = 120
mouseoverlabel = Localize("Move the cursor over an item to show more info")
boughtlabel = Localize("Already\nbought")
comingsoonlabel = Localize("Coming\nsoon")
majorlevel = 1

function OnLoad ()
	for i = 1, table.getn(shopitems), 1 do
		NX_GetBitmap(shopitems[i][4]);
		CacheSound(shopitems[i][6]);
	end;
	NX_GetBitmap("board/karma-token-0001.png");
end;


function OnEnter ()
	
	
	SetProperty("karma:label.text", GetGameValue("karma_tokens"))
	SetProperty("lives:label.text", GetGameValue("lives"))
	SetProperty("info:label.text", mouseoverlabel)
	
	--NX_GetBitmap("ui/gfx/blackgradient.png");
	majorlevel = GetGameValue ("level_major");
	for i = 1, table.getn(shopitems), 1 do
		y = GetProperty("dummy:position.y")+ (math.ceil(i/4)) * verspacing
		x = GetProperty("dummy:position.x")+ (i - ((math.ceil(i/4)-1)*4)) * horspacing	
		SetProperty("Buy"..i..":position.x", x-(55/2)-30)
		SetProperty("Buy"..i..":position.y", y+30)		
		
	end;
	AdministerScreen ()
end;

function AdministerScreen ()
	for i = 1, table.getn(shopitems), 1 do
		SetProperty("Buy"..i..":visible", 1)
		activeitems[i] = 1
		if(majorlevel < shopitems[i][5]) then
			SetProperty("Buy"..i..":visible", 0)
			activeitems[i] = 0
		end;
		if(GetGameValue("karma_tokens") < shopitems[i][2]) then
			SetProperty("Buy"..i..":visible", 0)
			activeitems[i] = 0
		end;
		if(i ~= 1 and GetGameValue("powerup_unlocked_"..shopitems[i][1]) == true) then
			SetProperty("Buy"..i..":visible", 0)
			activeitems[i] = 0
		end;
	end;
	SetProperty("lives:label.text", GetGameValue("lives"))
	

	
end; 

function OnLeave ()
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	--SetGameValue ("powerup_unlocked_fire", true);
	if (string.find(name, "Buy%d")) then
		_, _, number = string.find(name, "Buy(%d+)")
		
		Print("No:"..number.."\n")
		
		number = number+0
		SetProperty("/Confirmbuy/hiddenlabel:label.text", number)
		SetProperty("/Confirmbuy/hiddenlabelprice:label.text", shopitems[number][2])
		SetProperty("/Confirmbuy/picture:label.bitmap", shopitems[number][4])
		
		name = shopitems[number][1]
		SetProperty("/Confirmbuy/name:label.text", name)
		
		SetProperty("/Confirmbuy/price:label.text", "|ffc600|" .. shopitems[number][2])
		
		PushScreen("Confirmbuy");
	end;
	
	if (name == "Ok") then
		PopScreen ();
		return;
	end;
	

end;


function OnUpdate (tdelta)

	if(IsScreenInStack("Confirmbuy")) then
		return;
	end;
	akey = GetActiveScreenAnimKey ();
    mousex = NX_GetKeyState ("MOUSE_X")
    mousey = NX_GetKeyState ("MOUSE_Y")
    
    
    
    for i = 1, table.getn(shopitems), 1 do
		y = GetProperty("dummy:static_position.y")+ (math.ceil(i/4)) * verspacing
		x = GetProperty("dummy:static_position.x")+ (i - ((math.ceil(i/4)-1)*4)) * horspacing
		
		if(mousex > x-mouseoverareaw/2 and mousex < (x-mouseoverareaw/2+mouseoverareaw) and mousey > y-mouseoverareah/2 and mousey < (y-mouseoverareah/2+mouseoverareah)) then
			--SetProperty("info:label.text", "item:"..i)
			currentinfo = i		
			if (prevcurrentinfo ~= currentinfo and currentinfo ~= -1) then
				PlaySound(shopitems[i][6]);
				prevcurrentinfo = currentinfo;
				if(currentinfo == -1) then
					SetProperty("info:label.text", mouseoverlabel)
				else
					SetProperty("info:label.text", "|ffc600|"..shopitems[currentinfo][1]..": |ffffff| "..shopitems[currentinfo][3])
				end;
				spawnAppearFx("info")
			end;				
			break;
		end;	
	end;
	
	
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 600);
	-- SetProperty ("heading:alpha", trans);
	falpha = trans + trans * 0.05 * math.sin (2*3.141592*akey)
	SetProperty ("fader:alpha", falpha);
	
	timer = timer + tdelta
	if(timer - delay > 0.5) then
		delay = timer
		AdministerScreen()
	end;
end;

function spawnAppearFx(name)

	x = GetProperty(name..":static_position.x");
	y = GetProperty(name..":static_position.y");
	width = GetProperty(name..":width");
	height = GetProperty(name..":height");
	step = 40
	
	for k = y, y+height, step do
		for i = x, x+width, step do
			--Print("pos: ".. i.."\n")
			SpawnFX ("fxs/appear_cloud2.lua", i, k, 180, 0);	
		end;	
	end;
end;

function OnDraw ()
	
	
end;

function OnDrawComp(name)
	NX_SetTextAlign ("CENTER");
	for i = 1, table.getn(shopitems), 1 do
		y = GetProperty("dummy:static_position.y")+ (math.ceil(i/4)) * verspacing
		x = GetProperty("dummy:static_position.x")+ (i - ((math.ceil(i/4)-1)*4)) * horspacing
		--y = 20
		--NX_DrawBitmapAligned("ui/gfx/blackgradient.png", x, y, "CENTER");
	end;
	for i = 1, table.getn(shopitems), 1 do
		y = GetProperty("dummy:static_position.y")+ (math.ceil(i/4)) * verspacing
		x = GetProperty("dummy:static_position.x")+ (i - ((math.ceil(i/4)-1)*4)) * horspacing
		
		rotationsine = 0
		if(activeitems[i] == 1) then
		    rotationsine = 25 * math.sin(timer*100 / 30)
		end;
		
		NX_DrawBitmapRS (shopitems[i][4], x, y+6, rotationsine/180*3.1415926535, 1.0);
		
		NX_DrawText ("fonts/small.mft", x, y-50, shopitems[i][1]);
		
		

		if(i ~= 1 and GetGameValue("powerup_unlocked_"..shopitems[i][1]) == true) then
			NX_DrawText ("fonts/small.mft", x, y+55, "|00ff00|"..boughtlabel.. " |ffffff| ");
		elseif(activeitems[i] == 0) then
			NX_DrawText ("fonts/small.mft", x, y+55, "|ffc600|"..comingsoonlabel.. " |ffffff| ");
		end;
		
		NX_DrawText ("fonts/small.mft", x, y-28, "|ffc600|"..shopitems[i][2].. " |ffffff| ");
		
		NX_DrawBitmap ("board/karma-token-0001.png", x+15, y-36);
		--NX_DrawRect(x-45,y-60,90,120);
	end;	
	NX_SetTextAlign ("TOP LEFT");
end;